<?php

namespace App\Models\System_Models;

use App\Models\Stock_Models\StockLocation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class StockLocationDetail extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    /**
     * Get all of the stockLocations for the StockLocationDetail
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function stockLocations(): HasMany
    {
        return $this->hasMany(StockLocation::class, 'stock_location_detail_code', 'code');
    }

}