<?php

namespace App\Models\System_Models;

use App\Models\Stock_Models\StockLocation;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Role  extends Model {
    use HasFactory;
    protected $guarded = [];

    
    public function user()
    {
        return $this->belongsTo(User::class);
    }


    /**
     * Get the stockLocation that owns the UserRole
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function stockLocation(): BelongsTo
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
    /**
     * The mainNavigations that belong to the UserRole  
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function mainNavigations(): BelongsToMany
    {
        return $this->belongsToMany(MainNavigation::class, 'main_navigation_role',  'role_id', 'main_navigation_id');
    }

    public function levelOneNavigations(): BelongsToMany
    {
        return $this->belongsToMany(LevelOneNavigation::class, 'level_one_navigation_role',  'role_id', 'level_one_navigation_id');
    }

    public function levelTwoNavigations(): BelongsToMany
    {
        return $this->belongsToMany(LevelTwoNavigation::class, 'level_two_navigation_role',  'role_id', 'level_two_navigation_id');
    }

    public function reportMainNavigations(): BelongsToMany
    {
        return $this->belongsToMany(ReportMainNavigation::class, 'report_main_navigation_role',  'role_id', 'main_navigation_id');
    }

    public function reportLevelOneNavigations(): BelongsToMany
    {
        return $this->belongsToMany(ReportLevelOneNavigation::class, 'report_level_one_navigation_role', 'role_id', 'level_one_navigation_id');
    }
}
