<?php

namespace App\Models\System_Models;

use App\Models\UserRole;
use Illuminate\Database\Eloquent\Factories\BelongsToManyRelationship;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ReportMainNavigation extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];


    /**
     * The roles that belong to the MainNavigation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(Role::class, 'report_main_navigation_role', 'main_navigation_id', 'role_id');
    }

    /**
     * Get all of the levelOneNavigations for the MainNavigation
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function reportLevelOneNavigations(): HasMany
    {
        return $this->hasMany(ReportLevelOneNavigation::class, 'main_navigation_id', 'id');
    }
    
}