<?php

namespace App\Models\System_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ReportLevelOneNavigation extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];
    /**
     * Get the mainNavigation that owns the LevelOneNavigation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function mainNavigation(): BelongsTo
    {
        return $this->belongsTo(MainNavigation::class, 'main_navigation_id', 'id');
    }

    /**
     * The roles that belong to the MainNavigation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(Role::class, 'report_level_one_navigation_role', 'level_one_navigation_id', 'role_id');
    }
}