<?php

namespace App\Models\System_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class LevelTwoNavigation extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    /**
     * Get the levelOneNavigation that owns the LevelTwoNavigation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function levelOneNavigation(): BelongsTo
    {
        return $this->belongsTo(LevelOneNavigation::class, 'level_one_navigation_id', 'id');
    }


     /**
     * The roles that belong to the MainNavigation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(Role::class, 'level_two_navigation_role', 'level_two_navigation_id', 'role_id');
    }
    
}
