<?php

namespace App\Models\Supplier_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class SupplierAddress extends Model  implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];


    public function supplier() 
    {
        return $this->belongsTo(Supplier::class,'supplier_code', 'code');
    }
    
    public function setEmailAttribute($value)
    {
        $this-> attributes['email']=strtolower($value);
    }
}
