<?php

namespace App\Models\Supplier_Models;

use App\Models\PaymentVoucher_Models\SupplierBankPayment;
use App\Models\PaymentVoucher_Models\SupplierCardPayment;
use App\Models\PaymentVoucher_Models\SupplierChequePayment;
use App\Models\PaymentVoucher_Models\SupplierOnlineTransfer;
use App\Models\PaymentVoucher_Models\PaymentVoucher;
use App\Models\Stock_Models\Grn;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Supplier extends Model  implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];


    public function supplierAddresses()
    {
        return $this->hasMany(SupplierAddress::class, 'supplier_code', 'code');
    }

    public function supplierBillingAddresses()
    {
        return $this->hasMany(SupplierBillingAddress::class, 'supplier_code', 'code');
    }

    public function supplierShippingAddresses()
    {
        return $this->hasMany(SupplierShippingAddress::class, 'supplier_code', 'code');
    }

    public function grns()
    {
        return $this->hasMany(Grn::class, 'supplier_code', 'code');
    }

    public function paymentVouchers()
    {
        return $this->hasMany(PaymentVoucher::class, 'supplier_code', 'code');
    }

    public function supplierChequePayments()
    {
        return $this->hasMany(SupplierChequePayment::class, 'supplier_code', 'code');
    }

    public function supplierBankPayments()
    {
        return $this->hasMany(SupplierBankPayment::class, 'supplier_code', 'code');
    }

    public function supplierOnlinePayments()
    {
        return $this->hasMany(SupplierOnlineTransfer::class, 'supplier_code', 'code');
    }

    public function purchaseReturns()
    {
        return $this->hasMany(PurchaseReturn::class, 'supplier_code', 'code');
    }

    public function setEmailAttribute($value)
    {
        $this->attributes['email'] = strtolower($value);
    }
}
