<?php

namespace App\Models\Supplier_Models;

use App\Models\Stock_Models\Grn;
use App\Models\Stock_Models\StockHistory;
use App\Models\Stock_Models\StockLocation;
use App\Models\Supplier_Models\Supplier;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class PurchaseReturn extends Model  implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];


    public function supplier() 
    {
        return $this->belongsTo(Supplier::class,'supplier_code', 'code');
    }

    public function grn() 
    {
        return $this->belongsTo(Grn::class,'grn_code', 'code');
    }
    
    public function stockHistories() 
    {
        return $this->hasMany(StockHistory::class, 'source_code','code' );
    }
    
    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
}
