<?php

namespace App\Models\Stock_Models;

use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\StockIssue_Models\StockIssue;
use App\Models\Supplier_Models\PurchaseReturn;
use App\Models\System_Models\StockLocationDetail;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\BelongsToRelationship;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class StockLocation extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];


    public function stockIssues()
    {
        return $this->hasMany(StockIssue::class, 'stock_location_code', 'code');
    }

    public function salesReturns()
    {
        return $this->hasMany(SalesReturn::class, 'stock_location_code', 'code');
    }

    public function purchaseReturns()
    {
        return $this->hasMany(PurchaseReturn::class, 'stock_location_code', 'code');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'stock_location_code', 'code');
    }

    public function grns()
    {
        return $this->hasMany(Grn::class, 'stock_location_code', 'code');
    }

    public function stocks()
    {
        return $this->hasMany(StockHistory::class, 'stock_location_code', 'code');
    }

    public function stockTransfer()
    {
        return
            $this->hasMany(StockTransfer::class, 'stock_location_code_from', 'code');
        $this->hasMany(StockTransfer::class, 'stock_location_code_to', 'code');
    }

    public function stockIns()
    {
        return $this->hasMany(StockIn::class, 'stock_location_code', 'code');
    }

    /**
     * The users that belong to the StockLocation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(StockLocation::class, 'stock_location_user_roles', 'user_id', 'stock_location_code', 'id', 'code')
            ->withPivot('role_id', 'series');
    }


    /**
     * Get the stockLocationDetail that owns the StockLocation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function stockLocationDetail(): BelongsTo
    {
        return $this->belongsTo(StockLocationDetail::class, 'stock_location_detail_code', 'code');
    }
}
