<?php

namespace App\Models\Stock_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Stock_Models\StockHistoryTemp;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class StockHistoryTempExt extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function stockHistoryTemp() 
    {
        return $this->belongsTo(StockHistoryTemp::class, 'stock_history_temp_code','code' );
    }
}
