<?php

namespace App\Models\Stock_Models;

use App\Models\Customer_Models\SalesQuotation;
use App\Models\Customer_Models\SalesOrder;
use App\Models\Item_Models\ItemMaster;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class StockHistoryTemp extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function salesQuotation()
    {
        return $this->belongsTo(SalesQuotation::class, 'source_code', 'code');
    }

    public function salesOrder()
    {
        return $this->belongsTo(SalesOrder::class,'source_code','code');
    }

    public function itemMaster()
    {
        return $this->belongsTo(ItemMaster::class,'item_code','code');
    }

    public function StockHistoryTempExt()
    {
        return $this->belongsTo(StockHistoryTempExt::class, 'stock_history_temp_code','code' );
    }
    public function stock()
    {
        return $this->belongsTo(Stock::class, 'stock_code', 'code');
    }
}
