<?php

namespace App\Models\Stock_Models;


use App\Models\Invoice_Models\Invoice;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Stock_Models\StockHistory;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class StockHistoryExt extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'stock_history_code', 'code');
    }

    public function stockHistory() 
    {
        return $this->belongsTo(StockHistory::class, 'stock_history_code','code' );
    }
}
