<?php

namespace App\Models\Stock_Models;

use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\Item_Models\ItemMaster;
use App\Models\Stock_Models\StockHistoryExt;
use App\Models\StockIssue_Models\StockIssue;
use App\Models\Supplier_Models\PurchaseReturn;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class StockHistory extends Model  implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];


    public function grn()
    {
        return $this->belongsTo(Grn::class, 'source_code', 'code');
    }

    public function stockIn()
    {
        return $this->belongsTo(StockIn::class, 'source_code', 'code');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'source_code', 'code');
    }

    public function stockHistoryExt()
    {
        return $this->hasOne(StockHistoryExt::class, 'stock_history_code','code' );
    }
    
    public function salesReturn()
    {
        return $this->belongsTo(SalesReturn::class, 'source_code', 'code');
    }

    public function itemMaster() 
    {
        return $this->belongsTo(ItemMaster::class, 'item_code','code');
    }

    public function stock()
    {
        return $this->belongsTo(Stock::class, 'stock_code', 'code');
    }

    public function stockBatch()
    {
        return $this->hasMany(StockBatch::class, 'stock_history_code', 'code');
    }

    public function stockTransfer()
    {
        return $this->belongsTo(StockTransfer::class, 'source_code', 'code');
    }

    public function stockIssue()
    {
        return $this->belongsTo(StockIssue::class, 'source_code', 'code');
    }

    public function purchaseReturn()
    {
        return $this->belongsTo(PurchaseReturn::class, 'source_code', 'code');
    }
}
