<?php

namespace App\Models\Stock_Models;

use App\Models\Item_Models\ItemMaster;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Stock_Models\Grn;
use OwenIt\Auditing\Auditable;
use App\Models\Stock_Models\StockLocation;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Stock extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function itemMaster()
    {
        return $this->belongsTo(ItemMaster::class, 'item_code', 'code');
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
    
    public function grn()
    {
        return $this->belongsTo(Grn::class, 'grn_code', 'code');
    }

    public function stockHistories()
    {
        return $this->hasMany(StockHistory::class, 'stock_code', 'code');
    }
}
