<?php

namespace App\Models\Stock_Models;

use App\Models\Invoice_Models\Invoice;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Series extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded=[];

    public function invoices() 
    {
        return $this->hasMany(Invoice::class, 'series_code','code');
    }
}
