<?php

namespace App\Models\Stock_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Customer_Models\Customer;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class SalesRep extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded=[];

    
    public function routes()
    {
        return $this->hasMany(Route::class,'rep_code','code');
    }

    public function customers()
    {
        return $this->hasMany(Customer::class,'rep_code','code');
    }
}
