<?php

namespace App\Models\Stock_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use App\Models\Customer_Models\Customer;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use App\Models\User;


class Route extends Model  implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded=[];


    public function salesRep()
    {
        return $this->belongsTo(User::class,'rep_code','code');
    }

    public function customers()
    {
        return $this->hasMany(Customer::class,'route_code','code');
    }
}
