<?php

namespace App\Models\Stock_Models;

use App\Models\Item_Models\ItemMaster;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class MatureStock extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function itemMaster()
    {
        return $this->belongsTo(ItemMaster::class, 'item_code', 'code');
    }

    public function stock()
    {
        return $this->belongsTo(Stock::class, 'stock_code', 'code');
    }

    public function grn()
    {
        return $this->belongsTo(Grn::class, 'grn_code', 'code');
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
}