<?php

namespace App\Models\Stock_Models;

use App\Models\Item_Models\ItemMaster;
use App\Models\PaymentVoucher_Models\PaymentVoucher;
use App\Models\PaymentVoucher_Models\SupplierGrnPayment;
use App\Models\Supplier_Models\PurchaseReturn;
use App\Models\Supplier_Models\Supplier;
use App\Models\Stock_Models\Stock;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Grn extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];


    public function stockHistories() 
    {
        return $this->hasMany(StockHistory::class, 'source_code','code' );
    }

    public function supplier()
    {
       return $this->belongsTo(Supplier::class,'supplier_code', 'code');
    }

    public function purchaseReturns() 
    {
        return $this->hasMany(PurchaseReturn::class, 'grn_code','code' );
    }

    // public function supplierGrnPayments() 
    // {
    //     return $this->hasMany(SupplierGrnPayment::class, 'grn_code','code' );
    // }

    public function paymentVouchers()
    {
        return $this->belongsToMany(PaymentVoucher::class, 'grn_payment_vouchers','grn_code','payment_voucher_code');
    }
   
    public function stocks() 
    {
        return $this->hasMany(Stock::class, 'grn_code','code' );
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }

     // protected $casts = [
    //     'paid_amount' => 'float',
    //     'total_amount' => 'float',
    // ];

    // public function itemMasters() {
    //     return $this->hasMany(ItemMaster::class, 'item_code','code');
    // }

}
