<?php

namespace App\Models\StockIssue_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class StockIssueType extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps=false;
    protected $guarded = [];
    use Auditable;

    
    public function stockIssue()
    {
        return $this->belongsTo(StockIssue::class,'stock_issue_type_code','code');
    }
}
