<?php

namespace App\Models\StockIssue_Models;

use App\Models\Customer_Models\Customer;
use App\Models\Stock_Models\StockHistory;
use App\Models\Department_Models\Department;
use App\Models\Stock_Models\StockLocation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class StockIssue extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps=false;
    protected $guarded = [];
    use Auditable;

    
    public function customer()
    {
        return $this->belongsTo(Customer::class,'destination_code','code');
    }

    public function stockIssueType()
    {
        return $this->belongsTo(StockIssueType::class,'stock_issue_type_code','code');
    }

    public function department()
    {
        return $this->belongsTo(Department::class,'destination_code','code');
    }
    
    public function stockHistories() 
    {
        return $this->hasMany(StockHistory::class, 'source_code','code' );
    }
    
    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
}
