<?php

namespace App\Models\PaymentVoucher_Models;

use App\Models\Bank_Models\Bank;
use App\Models\Supplier_Models\Supplier;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class SupplierOnlineTransfer extends Model implements AuditableContract

{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function bank()
    {
        return $this->belongsTo(Bank::class,'bank_code','code');
    }

    public function supplier()
    {
        return $this->belongsTo(Supplier::class,'supplier_code','code');
    }

    function supplierModeOfPayment()
    {
        return $this->belongsTo(SupplierModeOfPayment::class,'supplier_mode_of_payment_code','code');
    }
}
