<?php

namespace App\Models\PaymentVoucher_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class SupplierModeOfPayment extends Model  implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps = false;
    protected $guarded = [];


    function paymentType()
    {
        return $this->belongsTo(paymentType::class, 'payment_type_code', 'code');
    }

    public function paymentVoucher()
    {
        return $this->belongsTo(PaymentVoucher::class, 'payment_voucher_code', 'code');
    }

    public function cardPayments()
    {
        return $this->hasMany(CardPayment::class, 'mode_of_payment_code', 'code');
    }

    public function chequePayments()
    {
        return $this->hasMany(ChequePayment::class, 'mode_of_payment_code', 'code');
    }
    
    public function cashPayments()
    {
        return $this->hasMany(CashPayment::class, 'mode_of_payment_code', 'code');
    }

    public function overPayments()
    {
        return $this->hasMany(OverPayment::class, 'mode_of_payment_code', 'code');
    }

    public function returnAmounts()
    {
        return $this->hasMany(ReturnAmount::class, 'mode_of_payment_code', 'code');
    }

    public function supplierCardPayments()
    {
        return $this->hasMany(SupplierCardPayment::class, 'supplier_mode_of_payment_code', 'code');
    }

    public function supplierBankPayments()
    {
        return $this->hasMany(SupplierBankPayment::class, 'supplier_mode_of_payment_code', 'code');
    }

    public function supplierOnlineTransfer()
    {
        return $this->hasMany(SupplierOnlineTransfer::class, 'supplier_mode_of_payment_code', 'code');
    }
}
