<?php

namespace App\Models\PaymentVoucher_Models;

use App\Models\Stock_Models\Grn;
use App\Models\Supplier_Models\Supplier;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Stock_Models\StockLocation;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class PaymentVoucher extends Model  implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_code', 'code');
    }

    public function supplierModeOfPayments()
    {
        return $this->hasMany(SupplierModeOfPayment::class, 'payment_voucher_code', 'code');
    }

    public function grns()
    {
        return $this->belongsToMany(Grn::class, 'grn_payment_vouchers', 'payment_voucher_code', 'grn_code');
    }
  
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
    
    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
}
