<?php

namespace App\Models\PaymentVoucher_Models;

use App\Models\Stock_Models\Grn;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\PaymentVoucher_Models\PaymentVoucher;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class GrnPaymentVoucher extends Model  implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    
    function supplierModeOfPayment()
    {
        return $this->belongsTo(SupplierModeOfPayment::class,'supplier_mode_of_payment_code','code');
    }

    function grn()
    {
        return $this->belongsTo(Grn::class,'grn_code','code');
    }

    public function paymentVoucher()
    {
        return $this->belongsTo(PaymentVoucher::class, 'payment_voucher_code','code');
    }
   
}
