<?php

namespace App\Models\PaymentReceipt_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ReturnAmount extends Model implements AuditableContract
{
    use HasFactory , Auditable;
    public $timestamps=false;
    protected $guarded = [];
    
    public function modeOfPayment()
    {
        return $this->belongsTo(ModeOfPayment::class, 'mode_of_payment_code', 'code');
    }
}
