<?php

namespace App\Models\PaymentReceipt_Models;

use App\Models\Expense_Models\Expense;
use App\Models\Expense_Models\ExpenseModeOfPayment;
use App\Models\Expense_Models\ExpensePayment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class PaymentType extends Model  implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps = false;
    protected $guarded = [];

    public function modeOfPayments()
    {
       return $this->hasMany(ModeOfPayment::class,'payment_type_code', 'code');
    }

    public function expenseModeOfPayments()
    {
       return $this->hasMany(ExpenseModeOfPayment::class,'payment_type_code', 'code');
    }

    public function expensePayments()
    {
        return $this->hasMany(ExpensePayment::class, 'payment_type_code', 'code');
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class, 'payment_type_code', 'code');
    }

    public function paymentReceipts()
    {
        return $this->hasMany(PaymentReceipt::class, 'payment_type_code', 'code');
    }
}
