<?php

namespace App\Models\PaymentReceipt_Models;

use App\Models\Customer_Models\Customer;
use App\Models\Invoice_Models\Invoice;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\PaymentReceipt_Models\ModeOfPayment;
use OwenIt\Auditing\Auditable;
use App\Models\Stock_Models\StockLocation;
use App\Models\User;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class PaymentReceipt extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function customer()
    {
        return $this->belongsTo(Customer::class,'customer_code','code');
    }

    public function modeOfPayments()
    {
       return $this->hasMany(ModeOfPayment::class,'payment_receipt_code', 'code');
    }

    public function invoices()
    {
        return $this->belongsToMany(Invoice::class, 'invoice_payment_receipts','payment_receipt_code','invoice_code', 'code', 'code');
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
}
