<?php

namespace App\Models\PaymentReceipt_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\PaymentReceipt_Models\CashPayment;
use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\PaymentReceipt_Models\BankPayment;
use App\Models\PaymentReceipt_Models\CardPayment;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ModeOfPayment extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    function paymentType()
    {
        return $this->belongsTo(paymentType::class, 'payment_type_code','code');
    }

    public function paymentReceipt()
    {
        return $this->belongsTo(PaymentReceipt::class, 'payment_receipt_code', 'code');
    }

    public function invoicePaymentReceipts()
    {
        return $this->hasMany(InvoicePaymentReceipt::class, 'mode_of_payment_code','code');
    }

    public function cardPayments()
    {
        return $this->hasMany(CardPayment::class, 'mode_of_payment_code','code');
    }

    public function bankPayments()
    {
        return $this->hasMany(BankPayment::class, 'mode_of_payment_code','code');
    }

    public function onlineTransferPayment()
    {
        return $this->hasMany(OnlineTransferPayment::class, 'mode_of_payment_code','code');
    }

    public function chequePayments()
    {
        return $this->hasMany(ChequePayment::class, 'mode_of_payment_code','code');
    }
    
    public function cashPayments()
    {
        return $this->hasMany(CashPayment::class, 'mode_of_payment_code','code');
    }

    public function overPayments()
    {
        return $this->hasMany(OverPayment::class, 'mode_of_payment_code','code');
    }

    public function returnAmounts()
    {
        return $this->hasMany(ReturnAmount::class, 'mode_of_payment_code','code');
    }
}
