<?php

namespace App\Models\PaymentReceipt_Models;

use App\Models\Invoice_Models\Invoice;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\PaymentReceipt_Models\ModeOfPayment;
use App\Models\PaymentReceipt_Models\PaymentReceipt;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class InvoicePaymentReceipt extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];
    
    function modeOfPayment()
    {
        return $this->belongsTo(ModeOfPayment::class,'mode_of_payment_code','code');
    }

    function invoice()
    {
        return $this->belongsTo(Invoice::class,'invoice_code','code');
    }

    function paymentReceipt()
    {
        return $this->belongsTo(PaymentReceipt::class,'payment_receipt_code','code');
    }
}
