<?php

namespace App\Models\PaymentReceipt_Models;

use App\Models\Bank_Models\Bank;
use App\Models\Bank_Models\BankBranch;
use App\Models\Customer_Models\Customer;
use App\Models\CustomerChequeReturnPayment_Models\CusCheqReturnReceipt;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class ChequePayment extends Model  implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function bank()
    {
        return $this->belongsTo(Bank::class,'bank_code', 'code');
    }

    public function bankBranch()
    {
        return $this->belongsTo(BankBranch::class, 'branch_code','code');
    }

    public function modeOfPayment()
    {
        return $this->belongsTo(ModeOfPayment::class, 'mode_of_payment_code', 'code');
    }
    
    public function cusCheqReturnReceipts()    
    {
        return $this->belongsToMany(CusCheqReturnReceipt::class, 'cheq_pay_cust_cheq_receipts', 'cheque_paym_code', 'cheque_receipt_code');
    }

    public function customer() 
    {
        return $this->belongsTo(Customer::class, 'customer_code' ,'code');
    }
}


