<?php

namespace App\Models\PaymentReceipt_Models;

use App\Models\Bank_Models\Bank;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class BankPayment extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps = false;
    protected $guarded = [];

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_code', 'code');
    }

    public function paymentReceipt()
    {
       return $this->belongsTo(PaymentReceipt::class,'payment_receipt_code','code');
    }
}
