<?php

namespace App\Models\Item_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;



class ItemSubCategory extends Model  implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];


    public function category()
    {
        return $this->belongsTo(ItemCategory::class, 'category_code', 'code');
    }

    public function itemMasters()
    {
        return $this->hasMany(ItemMaster::class,'sub_category_code','code');
    }
}
