<?php

namespace App\Models\Item_Models;

use App\Models\Invoice_Models\SalesOrderData;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\Stock_Models\StockHistoryTemp;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

use App\Models\Stock_Models\Grn;
use App\Models\Stock_Models\Stock;
use App\Models\Stock_Models\StockHistory;
use App\Models\Vehicle_Models\ServicePackageData;

class ItemMaster extends Model  implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded=[];


    public function itemCategory()
    {
        return $this->belongsTo(ItemCategory::class, 'category_code', 'code');
    }

    public function itemSubCategory()
    {
        return $this->belongsTo(ItemSubCategory::class, 'sub_category_code','code');
    }

    public function itemUnit()
    {
        return $this->belongsTo(ItemUnit::class,'unit_code','code');
    }

    public function itemBrand()
    {
        return $this->belongsTo(ItemBrand::class,'brand_code','code');
    }

    public function itemColor()
    {
        return $this->belongsTo(ItemColor::class,'color_code','code');
    }
    public function itemSize()
    {
        return $this->belongsTo(ItemSize::class,'size_code','code');
    }

    public function itemBinLocation()
    {
        return $this->belongsTo(ItemBinLocation::class,'bin_location_code','code');
    }

    public function itemImages()
    {
        return $this->hasMany(ItemImage::class, 'item_code', 'code');
    }

    public function stockHistories()
    {
        return $this->hasMany(StockHistory::class,'item_code', 'code');
    }

    public function salesReturns()
    {
        return $this->hasMany(SalesReturn::class, 'item_code','code');
    }

    public function stocks()
    {
       return $this->hasMany(Stock::class,'item_code','code');
    }

    public function stockHistoryTemps()
    {
        return $this->hasMany(StockHistoryTemp::class,'item_code','code');
    }

    public function servicePackageData()
    {
        return $this->hasMany(ServicePackageData::class,'item_code','code');
    }

    // public function salesOrderData()
    // {
    //     return $this->hasMany(SalesOrderData::class,'item_code','code');
    // }

    // public function servicePackageData()
    // {
    //     return $this->hasMany(ServicePackageData::class,'item_code','code');
    // }

    // public function selesQuotationData()
    // {
    //     return $this->hasMany(SalesOrderData::class,'item_code','code');
    // }

}
