<?php

namespace App\Models\Item_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class ItemCategory extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps=false;
    protected $guarded = [];
    use Auditable;

    public function itemSubCategories()
    {
        return $this->hasMany(ItemSubCategory::class, 'category_code', 'code');
    }

    public function itemMasters()
    {
        return $this->hasMany(ItemMaster::class, 'category_code', 'code');
    }    
}
