<?php

namespace App\Models\Invoice_Models;

use App\Models\Customer_Models\Customer;
use App\Models\Item_Models\ItemMaster;
use App\Models\Stock_Models\StockLocation;
use App\Models\Invoice_Models\Invoice;
use App\Models\Stock_Models\StockHistory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class SalesReturn extends Model   implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded=[];


    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_code','code');
    }

    public function itemMaster()
    {
        return $this->belongsTo(ItemMaster::class, 'item_code','code');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_code','code');
    }

    public function stockHistories() 
    {
        return $this->hasMany(StockHistory::class, 'source_code','code' );
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
}
