<?php

namespace App\Models\Invoice_Models;

use OwenIt\Auditing\Auditable;
use Illuminate\Database\Eloquent\Model;
use App\Models\Customer_Models\Customer;
use App\Models\Customer_Models\SalesOrder;
use App\Models\Stock_Models\StockLocation;
use App\Models\Stock_Models\StockHistoryTemp;
use App\Models\Customer_Models\SalesQuotation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class InvoiceTemps extends Model implements AuditableContract

{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded=[];


    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_code' ,'code');
    }
    public function stockHistoryTemp()
    {
        return $this->hasMany(StockHistoryTemp::class, 'source_code','code' );
    }
    public function salesQuotation()
    {
       return $this->belongsTo(SalesQuotation::class, 'sales_quotation_code','code');
    }

    public function salesOrder()
    {
       return $this->belongsTo(SalesOrder::class,'sales_order_code','code');
    }
    
    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }

}
