<?php

namespace App\Models\Invoice_Models;

use App\Models\Customer_Models\Customer;
use App\Models\Payment_Models\BillPayment;
use App\Models\Stock_Models\StockHistory;
use App\Models\Vehicle_Models\VehicleMaster;
use App\Models\Vehicle_Models\ServicePackage;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;



class InvoiceExt extends Model   implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded=[];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_code', 'code');
    }
    public function vehicleMaster()
    {
       return $this->belongsTo(VehicleMaster::class, 'vehicle_master_code','code');
    }
}
