<?php

namespace App\Models\Invoice_Models;

use App\Models\Customer_Models\Customer;
use App\Models\Customer_Models\SalesQuotation;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\Invoice_Models\InvoiceExt;
use App\Models\Stock_Models\StockHistory;
use App\Models\Customer_Models\SalesOrder;
use App\Models\Stock_Models\Series;
use App\Models\Stock_Models\StockHistoryExt;
use App\Models\Vehicle_Models\VehicleMaster;
use App\Models\Vehicle_Models\ServicePackage;
use App\Models\Stock_Models\StockLocation;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;



class Invoice extends Model   implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded=[];

    public function vehicleMaster()
    {
        return $this->belongsTo(VehicleMaster::class, 'vehicle_master_code', 'code');
    }

    public function stockHistories()
    {
        return $this->hasMany(StockHistory::class, 'source_code','code' );
    }

    public function stockHistoryExts()
    {
        return $this->hasMany(StockHistoryExt::class, 'stock_history_code','code' );
    }

    public function invoiceExt()
    {
        return $this->hasOne(InvoiceExt::class, 'invoice_code','code' );
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_code' ,'code');
    }

    public function salesReturns()
    {
        return $this->hasMany(SalesReturn::class, 'invoice_code','code');
    }

    public function paymentReceipts()
    {
        return $this->belongsToMany(PaymentReceipt::class, 'invoice_payment_receipts','invoice_code','payment_receipt_code', 'code', 'code')
        ->withPivot(['outstanding','paid_amount']); // this column from intermediate table for sales reconciliation report need particular receipt outstanding amount
    }


    public function salesQuotation()
    {
       return $this->belongsTo(SalesQuotation::class, 'sales_quotation_code','code');
    }

    public function salesOrder()
    {
       return $this->belongsTo(SalesOrder::class,'sales_order_code','code');
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }

    public function series()
    {
        return $this->belongsTo(Series::class, 'series_code', 'code');
    }

    public function servicePackage()
    {
       return $this->belongsToMany(servicePackage::class,'invoice_service_packages','invoice_code','service_package_code');
    }

    public function billPayment()
    {
        return $this->hasMany(billPayment::class, 'invoice_code','code');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
}
