<?php

namespace App\Models\Expense_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ExpenseType extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function expenseCategories()
    {
        return $this->belongsTo(ExpenseCategory::class,'expense_category_code','code');
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class,'expense_type_code','code');
    }
}
