<?php

namespace App\Models\Expense_Models;

use App\Models\PaymentReceipt_Models\Bank;
use App\Models\PaymentReceipt_Models\PaymentType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ExpensePayment extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function expense()
    {
        return $this->belongsTo(Expense::class, 'expense_code', 'code');
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class,'bank_code','code');
    }

    // public function paymentType()
    // {
    //     return $this->belongsTo(PaymentType::class);
    // }

     public function paymentType()
     {
        return $this->belongsTo(PaymentType::class,'payment_type_code','code');
     }
}
