<?php

namespace App\Models\Expense_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\PaymentReceipt_Models\PaymentType;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ExpenseModeOfPayment extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    function paymentType()
    {
        return $this->belongsTo(paymentType::class, 'payment_type_code','code');
    }

    public function expense()
    {
        return $this->belongsTo(Expense::class, 'expense_code', 'code');
    }

    public function expenseCardPayments()
    {
        return $this->hasMany(ExpenseCardPayment::class, 'mode_of_payment_code','code');
    }

    public function expenseBankPayments()
    {
        return $this->hasMany(ExpenseBankPayment::class, 'mode_of_payment_code','code');
    }

    public function expenseOnlinePayments()
    {
        return $this->hasMany(ExpenseOnlinePayment::class, 'mode_of_payment_code','code');
    }

    public function expenseChequePayments()
    {
        return $this->hasMany(ExpenseChequePayment::class, 'mode_of_payment_code','code');
    }

    public function expenseCashPayments()
    {
        return $this->hasMany(ExpenseCashPayment::class, 'mode_of_payment_code','code');
    }
}
