<?php

namespace App\Models\Expense_Models;

use App\Models\Bank_Models\Bank;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ExpenseChequePayment extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_code', 'code');
    }

    public function bankBranch()
    {
        return $this->belongsTo(BankBranch::class, 'branch_code','code');
    }
    
    public function expenseModeOfPayment()
    {
        return $this->belongsTo(ExpenseModeOfPayment::class, 'mode_of_payment_code', 'code');
    }
}
