<?php

namespace App\Models\Expense_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ExpenseCategory extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function expenseTypes()
    {
        return $this->hasMany(ExpenseType::class,'expense_category_code','code');
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class,'expense_category_code','code');
    }
}
