<?php

namespace App\Models\Expense_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ExpenseCashPayment extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function expenseModeOfPayment()
    {
        return $this->belongsTo(ExpenseModeOfPayment::class, 'mode_of_payment_code', 'code');
    }
}
