<?php

namespace App\Models\Expense_Models;

use App\Models\PaymentReceipt_Models\Bank;
use App\Models\PaymentReceipt_Models\PaymentType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Stock_Models\StockLocation;
use App\Models\User;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Expense extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    public function expenseType()
    {
        return $this->belongsTo(ExpenseType::class,'expense_type_code','code');
    }

    public function expenseCategory()
    {
        return $this->belongsTo(ExpenseCategory::class,'expense_category_code','code');
    }

    public function bank()
    {
       return $this->belongsTo(Bank::class,'bank_code', 'code');
    }

    public function paymentType()
    {
       return $this->belongsTo(PaymentType::class,'payment_type_code','code');
    }

    public function expensePayments()
    {
        return $this->hasMany(ExpensePayment::class, 'expense_code', 'code');
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }

    public function expenseModeOfPayments()
    {
       return $this->hasMany(ExpenseModeOfPayment::class,'expense_code', 'code');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

}
