<?php

namespace App\Models\Customer_Models;

use App\Models\Customer_Models\Customer;
use App\Models\Invoice_Models\Invoice;
use App\Models\Stock_Models\StockHistoryTemp;
use App\Models\Stock_Models\StockHistoryTempExt;
use App\Models\Stock_Models\StockLocation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;



class SalesOrder extends Model   implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded=[];

    // public function salesOrderData()
    // {
    //     return $this->hasMany(SalesOrderData::class,'sales_order_code','code');
    // }

    public function stockHistoryTemps()
    {
        return $this->hasMany(StockHistoryTemp::class,'source_code','code');
    }

    public function StockHistoryTempExts()
    {
        return $this->hasMany(StockHistoryTempExt::class, 'stock_history_temp_code','code' );
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class,'customer_code','code');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class,'sales_order_code','code');
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class,'stock_location_detail_code','code');
    }

}
