<?php

namespace App\Models\Customer_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class CustomerType extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps=false;
    protected $guarded = [];
    use Auditable;

    //Many to many -------------
//customer_types --- table  customer_code->(foreign key) customer_code -> comming from Customer table

      public function customers()
      {
          return $this->hasMany(Customer::class, 'customer_type_code', 'code');
      }
}


