<?php

namespace App\Models\Customer_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;



class CustomerBillingAddress extends Model implements  AuditableContract
{
    use HasFactory;
    public $timestamps=false;
    protected $guarded = [];
    use Auditable;

    
    public function customer() 
    {
        return $this->belongsTo(Customer::class,'customer_code' ,'code');
    }
}


