<?php

namespace App\Models\Customer_Models;


use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\CustomerChequeReturnPayment_Models\CusCheqReturnReceipt;
use App\Models\StockIsssue_Models\StockIsssue;
use App\Models\Stock_Models\Route;
use App\Models\Stock_Models\SalesRep;
use App\Models\StockIssue_Models\StockIssue;
use App\Models\Vehicle_Models\VehicleMaster;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class Customer extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps=false;
    protected $guarded = [];
    use Auditable;

//One to many -----
    public function customerBillingAddresses()
    {
        return $this->hasMany( CustomerBillingAddress::class, 'customer_code' , 'code');
    }

    public function customerShippingAddresses()
    {
        return $this->hasMany( CustomerShippingAddress::class, 'customer_code' ,'code' );
    }

    public function customerAddresses()
    {
        return $this->hasMany( CustomerAddress::class, 'customer_code' ,'code');
    }

    public function customerType()
    {
        return $this->belongsTo( CustomerType::class,'customer_type_code' , 'code');
    }

    public function customerContacts()
    {
        return $this->hasMany( CustomerContact::class,'customer_code', 'code');
    }

    public function salesOrders()
    {
       return $this->hasMany(SalesOrder::class,'customer_code','code');
    }

    public function salesQuotations()
    {
        return $this->hasMany(SalesQuotation::class,'customer_code','code');
    }

    public function stockIsssues()
    {
        return $this->hasMany(StockIssue::class,'destination_code','code');
    }

    public function vehicleMasters()
    {
       return $this->hasMany(VehicleMaster::class,'customer_code','code');
    }

    public function paymentReceipts()
    {
        return $this->hasMany(PaymentReceipt::class,'customer_code','code');
    }

    public function cusCheqReturnReceipt()
    {
        return $this->hasMany(CusCheqReturnReceipt::class,'customer_code','code');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class,'customer_code','code');
    }

    public function salesReturns()
    {
        return $this->hasMany(SalesReturn::class, 'customer_code','code');
    }

    public function chequePayments()
    {
        return $this->hasMany(ChequePayment::class, 'customer_code','code');
    }

    public function salesRep()
    {
        return $this->belongsTo(SalesRep::class,'rep_code','code');
    }

    public function route()
    {
        return $this->belongsTo(Route::class,'route_code','code');
    }

}
